#include "GetPoint.js"

function DoArcCenter()
{
	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return;

	ui.beginUIUpdate();
	ui.hideUI( 'CenterPrompt' );
	ui.showUI( 'StartPointPrompt' );
	ui.endUIUpdate();
	
	var centerpt = pointpicker.pt;

	var arcfactory = moi.command.createFactory( 'arccenter' );

	arcfactory.setInput( 0, pointpicker.ptframe );

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, true );
	pointpicker.stickToSurfacesMode = 'max';
	pointpicker.disableVerticalStraightSnap = true;

	pointpicker.bindResultPt( arcfactory.getInput(1) );
	pointpicker.bindResultOrientation( arcfactory.getInput(0) );

	if ( !GetPoint( pointpicker ) )
		return;
		
	ui.bindUIToInput( 'elliptical', 'value', arcfactory.getInput(4) );
		
	ui.beginUIUpdate();
	ui.hideUI( 'StartPointPrompt' );
	ui.showUI( 'EndPointPrompt' );
	
	if ( ui.commandUI.elliptical.value == false )
		ui.showUI( 'AngleOptions' );
		
	ui.endUIUpdate();
		
	pointpicker.restrictToPlane( arcfactory.getInput(0).getValue(), true );
	pointpicker.setBasePt( centerpt );
	
	pointpicker.clearBindings();
	pointpicker.bindResultPt( arcfactory.getInput(2) );
	
	ui.commandUI.g_ArcFactory = arcfactory;
	pointpicker.bindFunc( ui.commandUI.OnPoint );
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'elliptical' )
		{
			ui.beginUIUpdate();
		
			if ( ui.commandUI.elliptical.value )
				ui.hideUI( 'AngleOptions' );
			else
				ui.showUI( 'AngleOptions' );
			
			ui.endUIUpdate();
		}
		else if ( pointpicker.event == 'angleinput' )
		{
			arcfactory.setInput( 3, ui.commandUI.angleinput.value );
			arcfactory.update();
			break;
		}
		else if ( pointpicker.event == 'lengthinput' )
		{
		    arcfactory.length = ui.commandUI.lengthinput.value;
		    arcfactory.update();
		    break;
        }
		else if ( pointpicker.event == 'finished' )
		{
			break;
		}
	}

	arcfactory.commit();
}

DoArcCenter();
